/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.wall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.doors.Doorway;
import technology.rocketjump.undermount.doors.DoorwayOrientation;
import technology.rocketjump.undermount.doors.DoorwaySize;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.guice.WallEdgeAtlasProvider;
import technology.rocketjump.undermount.mapping.tile.wall.Edge;
import technology.rocketjump.undermount.mapping.tile.wall.WallEdgeDefinition;

@ProvidedBy(value=WallEdgeAtlasProvider.class)
@Singleton
public class WallEdgeAtlas {
    private IntMap<WallEdgeDefinition> layoutToDefinitionMap = new IntMap(256);
    private Map<String, Float> coordinateTranslationMap = new HashMap<String, Float>();
    private Map<EntityAssetOrientation, Map<GameMaterialType, WallEdgeDefinition>> wallCapDefinitionMap = new HashMap<EntityAssetOrientation, Map<GameMaterialType, WallEdgeDefinition>>();
    private Map<DoorwaySize, Map<DoorwayOrientation, Map<GameMaterialType, WallEdgeDefinition>>> doorwayDefinitionMap = new HashMap<DoorwaySize, Map<DoorwayOrientation, Map<GameMaterialType, WallEdgeDefinition>>>();

    public WallEdgeAtlas(File edgeVerticesFile, File wallCapEdgeVerticesFile, File DoorwayEdgeVerticesFile) throws IOException {
        JSONObject wallEdgeFileJson = JSON.parseObject(FileUtils.readFileToString(edgeVerticesFile, "UTF-8"));
        JSONObject wallCapFileJson = JSON.parseObject(FileUtils.readFileToString(wallCapEdgeVerticesFile, "UTF-8"));
        JSONObject doorwayEdgeFileJson = JSON.parseObject(FileUtils.readFileToString(DoorwayEdgeVerticesFile, "UTF-8"));
        for (DoorwaySize doorwaySize : DoorwaySize.values()) {
            HashMap doorSizeMap = new HashMap();
            for (DoorwayOrientation doorwayOrientation : DoorwayOrientation.values()) {
                doorSizeMap.put(doorwayOrientation, new HashMap());
            }
            this.doorwayDefinitionMap.put(doorwaySize, doorSizeMap);
        }
        this.coordinateTranslationMap.put("0", Float.valueOf(0.0f));
        this.coordinateTranslationMap.put("x1", Float.valueOf(0.3125f));
        this.coordinateTranslationMap.put("x2", Float.valueOf(0.671875f));
        this.coordinateTranslationMap.put("y1", Float.valueOf(0.59375f));
        this.coordinateTranslationMap.put("y2", Float.valueOf(0.96875f));
        this.coordinateTranslationMap.put("1", Float.valueOf(1.0f));
        for (String layoutId : wallEdgeFileJson.keySet()) {
            JSONObject layoutJson = wallEdgeFileJson.getJSONObject(layoutId);
            WallEdgeDefinition definition = this.buildWallDefinitionFromJson(layoutJson);
            int layoutIdInteger = Integer.valueOf(layoutId);
            this.layoutToDefinitionMap.put(layoutIdInteger, definition);
        }
        for (String orientationName : wallCapFileJson.keySet()) {
            EntityAssetOrientation orientation = EntityAssetOrientation.valueOf(orientationName);
            JSONObject materialMapJson = wallCapFileJson.getJSONObject(orientationName);
            Map typeToDefinitions = this.wallCapDefinitionMap.computeIfAbsent(orientation, o -> new HashMap());
            for (String materialTypeName : materialMapJson.keySet()) {
                GameMaterialType materialType = GameMaterialType.valueOf(materialTypeName);
                JSONObject layoutJson = materialMapJson.getJSONObject(materialTypeName);
                WallEdgeDefinition definition = this.buildWallDefinitionFromJson(layoutJson);
                typeToDefinitions.put(materialType, definition);
            }
        }
        for (String doorwaySizeName : doorwayEdgeFileJson.keySet()) {
            DoorwaySize doorwaySize = DoorwaySize.valueOf(doorwaySizeName);
            JSONObject doorwaySizeJson = doorwayEdgeFileJson.getJSONObject(doorwaySizeName);
            for (String doorOrientationName : doorwaySizeJson.keySet()) {
                DoorwayOrientation doorOrientation = DoorwayOrientation.valueOf(doorOrientationName);
                JSONObject doorOrientationJson = doorwaySizeJson.getJSONObject(doorOrientationName);
                for (String materialTypeName : doorOrientationJson.keySet()) {
                    GameMaterialType materialType = GameMaterialType.valueOf(materialTypeName);
                    JSONObject layoutJson = doorOrientationJson.getJSONObject(materialTypeName);
                    WallEdgeDefinition definition = this.buildWallDefinitionFromJson(layoutJson);
                    this.doorwayDefinitionMap.get((Object)doorwaySize).get((Object)doorOrientation).put(materialType, definition);
                }
            }
        }
    }

    private WallEdgeDefinition buildWallDefinitionFromJson(JSONObject layoutJson) {
        Array<Edge> innerEdges = new Array<Edge>();
        JSONArray innerEdgeArray = layoutJson.getJSONArray("inner");
        for (int cursor = 0; cursor < innerEdgeArray.size(); ++cursor) {
            JSONArray pointArray = innerEdgeArray.getJSONArray(cursor);
            innerEdges.add(this.pointArrayToWallEdge(pointArray));
        }
        Array<Edge> outerEdges = new Array<Edge>();
        JSONArray outerEdgeArray = layoutJson.getJSONArray("outer");
        for (int cursor = 0; cursor < outerEdgeArray.size(); ++cursor) {
            JSONArray pointArray = outerEdgeArray.getJSONArray(cursor);
            outerEdges.add(this.pointArrayToWallEdge(pointArray));
        }
        return new WallEdgeDefinition(innerEdges, outerEdges);
    }

    public WallEdgeDefinition getForLayoutId(int layoutId) {
        if (!this.layoutToDefinitionMap.containsKey(layoutId)) {
            throw new RuntimeException(this.getClass().getName() + " does not contain an entry for " + layoutId);
        }
        return this.layoutToDefinitionMap.get(layoutId);
    }

    public WallEdgeDefinition getForWallCap(Entity wallCapEntity, Doorway doorway) {
        EntityAssetOrientation orientation = wallCapEntity.getLocationComponent().getOrientation();
        GameMaterialType materialType = doorway.getDoorwayMaterialType();
        return this.wallCapDefinitionMap.get((Object)orientation).get((Object)materialType);
    }

    public WallEdgeDefinition getForClosedDoor(Doorway doorway) {
        return this.doorwayDefinitionMap.get((Object)doorway.getDoorwaySize()).get((Object)doorway.getOrientation()).get((Object)doorway.getDoorwayMaterialType());
    }

    private Edge pointArrayToWallEdge(JSONArray pointArray) {
        return new Edge(new Vector2(this.translatePoint(pointArray.getString(0)), this.translatePoint(pointArray.getString(1))), new Vector2(this.translatePoint(pointArray.getString(2)), this.translatePoint(pointArray.getString(3))));
    }

    private float translatePoint(String pointValue) {
        if (this.coordinateTranslationMap.containsKey(pointValue)) {
            return this.coordinateTranslationMap.get(pointValue).floatValue();
        }
        return Float.valueOf(pointValue).floatValue();
    }
}

